﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace LINQ_to_XML
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 35 }, 
            new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 246813579, Wiek = 36 },
            new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", NumerTelefonu = 567891234, Wiek = 7 }, 
            new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 987654321, Wiek = 2 } 
        };

        private void button1_Click(object sender, EventArgs e)
        {        
            XDocument xml = new XDocument(
                new XDeclaration("1.0","utf-8","yes"),
                new XElement("ListaOsob",
                    from osoba in listaOsob
                    orderby osoba.Wiek
                    select new XElement("Osoba",
                              new XAttribute("Id", osoba.Id),
                              new XElement("Imię", osoba.Imię),
                              new XElement("Nazwisko", osoba.Nazwisko),
                              new XElement("NumerTelefonu", osoba.NumerTelefonu),
                              new XElement("Wiek", osoba.Wiek)
                    )
                )
            );

            xml.Save("Telefony.xml");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load("Telefony.xml");
            IEnumerable<string> listaOsobPelnoletnich = 
                from osoba in xml.Descendants("Osoba") 
                where int.Parse(osoba.Element("Wiek").Value) >= 18 
                orderby osoba.Element("Imię").Value 
                select osoba.Element("Imię").Value + " " + osoba.Element("Nazwisko").Value;

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (string personalia in listaOsobPelnoletnich) s += personalia + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load("Telefony.xml");
            IEnumerable<Osoba> listaOsobPelnoletnich = 
                from osoba in xml.Descendants("Osoba") 
                where int.Parse(osoba.Element("Wiek").Value) >= 18 
                orderby osoba.Element("Imię").Value 
                select new Osoba(){ 
                    Id = int.Parse(osoba.Attribute("Id").Value), 
                    Imię = osoba.Element("Imię").Value, 
                    Nazwisko = osoba.Element("Nazwisko").Value, 
                    NumerTelefonu = int.Parse(osoba.Element("NumerTelefonu").Value), 
                    Wiek = int.Parse(osoba.Element("Wiek").Value) };

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load("Telefony.xml");
            IEnumerable<XElement> listaOsob = xml.Descendants("Osoba").Where(osoba => (osoba.Element("Imię").Value == "Bartosz" && osoba.Element("Nazwisko").Value == "Matulewski"));
            if (listaOsob.Count() > 0) listaOsob.First().Element("Wiek").Value = (int.Parse(listaOsob.First().Element("Wiek").Value) + 1).ToString();
            else
            {
                MessageBox.Show("Brak osób o podanym imieniu i nazwisku");
                return;
            }
            xml.Save("Telefony.xml");
        }
    }
}
